<?php
require_once( "utility.php" ) ;
function get_image_type_id_by_vmpath( $argv ) {
	global $DTASCFG_XML_FILE ;

	/* check number of arguments */
	if( count( $argv ) != 1 ) {
        echo "Usage: " . basename( __FILE__, ".inc" ) . " <vmpath>" ;
		exit( 1 ) ;
	}

	$vmpath      = $argv[ 0 ] ;
    $xml         = simplexml_load_file( $DTASCFG_XML_FILE ) ;
    // $usbxcli     = chop( $xml -> u_sandbox -> cli_path ) ;
    // $sb_number   = chop( $xml -> sandbox -> number ) ;
    $db_host     = chop( $xml -> db -> host ) ;
    $db_user     = chop( $xml -> db -> username ) ;
    $db_password =       $xml -> db -> password ;

	
    $result = 0 ;
    try {
        
        # get db connection
        $connection = pg_connect( "host=$db_host dbname=dtasdb user=$db_user password=$db_password" ) ;
        if( $connection === false ) {
            throw new Exception( "ConnectToDbFail: host='$db_host', user='$db_user'" ) ;
        }
        
        $queryResult = pg_query_params( $connection,
                                        "SELECT key FROM tb_global_setting WHERE key LIKE $1 AND value = $2",
                                        array( "configuration.image_type.image_%.path",
                                               $vmpath ) ) ;
        if( $queryResult === false ) {
            throw new Exception( pg_last_error() ) ;
        }
        
        # non-empty result => vmpath exist
        if( pg_fetch_all( $queryResult ) !== false ) {
        
            # format: 'configuration.image_type.image_1.path'
            $record = pg_fetch_array( $queryResult, 0, PGSQL_NUM ) ;
            $key    = $record[ 0 ] ;
            $slices = explode( ".", $key ) ;
            $id     = explode( "_", $slices[ 2 ] ) ;
            
            $result = $id[ 1 ] ;
        }
        
        pg_close( $connection ) ;
        echo $result . "\n" ;
        exit( 0 ) ;
    }
    
    catch( Exception $e ) {
        if( $connection !== false ) {
            pg_close( $connection ) ;
        }
        
        $msg = "Exception caught: [" . $e -> getFile() . "(" . $e -> getLine() . ")]: " . $e -> getMessage() ;
        debug_print( $msg ) ;
        echo $msg ;
        exit( 1 ) ;
    }
}

